/*
 * Asterisk -- An open source telephony toolkit.
 *
 * Copyright (C) 2013, Digium, Inc.
 *
 * See http://www.asterisk.org for more information about
 * the Asterisk project. Please do not directly contact
 * any of the maintainers of this project for assistance;
 * the project provides a web site, mailing lists and IRC
 * channels for your use.
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License Version 2. See the LICENSE file
 * at the top of the source tree.
 */

/*! \file
 *
 * \brief Generated file - Build validators for ARI model objects.
 */

 /*
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * !!!!!                               DO NOT EDIT                        !!!!!
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * This file is generated by a mustache template. Please see the original
 * template in rest-api-templates/ari_model_validators.c.mustache
 */

#include "asterisk.h"

#include "asterisk/logger.h"
#include "asterisk/module.h"
#include "ari_model_validators.h"

int ast_ari_validate_asterisk_info(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("build", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_build_info(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI AsteriskInfo field build failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("config", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_config_info(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI AsteriskInfo field config failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("status", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_status_info(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI AsteriskInfo field status failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("system", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_system_info(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI AsteriskInfo field system failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI AsteriskInfo has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	return res;
}

ari_validator ast_ari_validate_asterisk_info_fn(void)
{
	return ast_ari_validate_asterisk_info;
}

int ast_ari_validate_asterisk_ping(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_asterisk_id = 0;
	int has_ping = 0;
	int has_timestamp = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_asterisk_id = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI AsteriskPing field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("ping", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_ping = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI AsteriskPing field ping failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI AsteriskPing field timestamp failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI AsteriskPing has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_asterisk_id) {
		ast_log(LOG_ERROR, "ARI AsteriskPing missing required field asterisk_id\n");
		res = 0;
	}

	if (!has_ping) {
		ast_log(LOG_ERROR, "ARI AsteriskPing missing required field ping\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI AsteriskPing missing required field timestamp\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_asterisk_ping_fn(void)
{
	return ast_ari_validate_asterisk_ping;
}

int ast_ari_validate_build_info(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_date = 0;
	int has_kernel = 0;
	int has_machine = 0;
	int has_options = 0;
	int has_os = 0;
	int has_user = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("date", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_date = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BuildInfo field date failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("kernel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_kernel = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BuildInfo field kernel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("machine", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_machine = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BuildInfo field machine failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("options", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_options = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BuildInfo field options failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("os", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_os = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BuildInfo field os failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("user", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_user = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BuildInfo field user failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI BuildInfo has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_date) {
		ast_log(LOG_ERROR, "ARI BuildInfo missing required field date\n");
		res = 0;
	}

	if (!has_kernel) {
		ast_log(LOG_ERROR, "ARI BuildInfo missing required field kernel\n");
		res = 0;
	}

	if (!has_machine) {
		ast_log(LOG_ERROR, "ARI BuildInfo missing required field machine\n");
		res = 0;
	}

	if (!has_options) {
		ast_log(LOG_ERROR, "ARI BuildInfo missing required field options\n");
		res = 0;
	}

	if (!has_os) {
		ast_log(LOG_ERROR, "ARI BuildInfo missing required field os\n");
		res = 0;
	}

	if (!has_user) {
		ast_log(LOG_ERROR, "ARI BuildInfo missing required field user\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_build_info_fn(void)
{
	return ast_ari_validate_build_info;
}

int ast_ari_validate_config_info(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_default_language = 0;
	int has_name = 0;
	int has_setid = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("default_language", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_default_language = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigInfo field default_language failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("max_channels", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigInfo field max_channels failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("max_load", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigInfo field max_load failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("max_open_files", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigInfo field max_open_files failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigInfo field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("setid", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_setid = 1;
			prop_is_valid = ast_ari_validate_set_id(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigInfo field setid failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ConfigInfo has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_default_language) {
		ast_log(LOG_ERROR, "ARI ConfigInfo missing required field default_language\n");
		res = 0;
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI ConfigInfo missing required field name\n");
		res = 0;
	}

	if (!has_setid) {
		ast_log(LOG_ERROR, "ARI ConfigInfo missing required field setid\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_config_info_fn(void)
{
	return ast_ari_validate_config_info;
}

int ast_ari_validate_config_tuple(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_attribute = 0;
	int has_value = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("attribute", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_attribute = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigTuple field attribute failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("value", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_value = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ConfigTuple field value failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ConfigTuple has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_attribute) {
		ast_log(LOG_ERROR, "ARI ConfigTuple missing required field attribute\n");
		res = 0;
	}

	if (!has_value) {
		ast_log(LOG_ERROR, "ARI ConfigTuple missing required field value\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_config_tuple_fn(void)
{
	return ast_ari_validate_config_tuple;
}

int ast_ari_validate_log_channel(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_channel = 0;
	int has_configuration = 0;
	int has_status = 0;
	int has_type = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LogChannel field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("configuration", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_configuration = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LogChannel field configuration failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("status", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_status = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LogChannel field status failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LogChannel field type failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI LogChannel has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI LogChannel missing required field channel\n");
		res = 0;
	}

	if (!has_configuration) {
		ast_log(LOG_ERROR, "ARI LogChannel missing required field configuration\n");
		res = 0;
	}

	if (!has_status) {
		ast_log(LOG_ERROR, "ARI LogChannel missing required field status\n");
		res = 0;
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI LogChannel missing required field type\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_log_channel_fn(void)
{
	return ast_ari_validate_log_channel;
}

int ast_ari_validate_module(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_description = 0;
	int has_name = 0;
	int has_status = 0;
	int has_support_level = 0;
	int has_use_count = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("description", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_description = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Module field description failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Module field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("status", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_status = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Module field status failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("support_level", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_support_level = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Module field support_level failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("use_count", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_use_count = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Module field use_count failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Module has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_description) {
		ast_log(LOG_ERROR, "ARI Module missing required field description\n");
		res = 0;
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI Module missing required field name\n");
		res = 0;
	}

	if (!has_status) {
		ast_log(LOG_ERROR, "ARI Module missing required field status\n");
		res = 0;
	}

	if (!has_support_level) {
		ast_log(LOG_ERROR, "ARI Module missing required field support_level\n");
		res = 0;
	}

	if (!has_use_count) {
		ast_log(LOG_ERROR, "ARI Module missing required field use_count\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_module_fn(void)
{
	return ast_ari_validate_module;
}

int ast_ari_validate_set_id(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_group = 0;
	int has_user = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("group", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_group = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI SetId field group failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("user", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_user = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI SetId field user failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI SetId has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_group) {
		ast_log(LOG_ERROR, "ARI SetId missing required field group\n");
		res = 0;
	}

	if (!has_user) {
		ast_log(LOG_ERROR, "ARI SetId missing required field user\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_set_id_fn(void)
{
	return ast_ari_validate_set_id;
}

int ast_ari_validate_status_info(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_last_reload_time = 0;
	int has_startup_time = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("last_reload_time", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_last_reload_time = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StatusInfo field last_reload_time failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("startup_time", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_startup_time = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StatusInfo field startup_time failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI StatusInfo has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_last_reload_time) {
		ast_log(LOG_ERROR, "ARI StatusInfo missing required field last_reload_time\n");
		res = 0;
	}

	if (!has_startup_time) {
		ast_log(LOG_ERROR, "ARI StatusInfo missing required field startup_time\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_status_info_fn(void)
{
	return ast_ari_validate_status_info;
}

int ast_ari_validate_system_info(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_entity_id = 0;
	int has_version = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("entity_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_entity_id = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI SystemInfo field entity_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("version", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_version = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI SystemInfo field version failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI SystemInfo has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_entity_id) {
		ast_log(LOG_ERROR, "ARI SystemInfo missing required field entity_id\n");
		res = 0;
	}

	if (!has_version) {
		ast_log(LOG_ERROR, "ARI SystemInfo missing required field version\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_system_info_fn(void)
{
	return ast_ari_validate_system_info;
}

int ast_ari_validate_variable(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_value = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("value", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_value = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Variable field value failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Variable has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_value) {
		ast_log(LOG_ERROR, "ARI Variable missing required field value\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_variable_fn(void)
{
	return ast_ari_validate_variable;
}

int ast_ari_validate_endpoint(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_channel_ids = 0;
	int has_resource = 0;
	int has_technology = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("channel_ids", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel_ids = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Endpoint field channel_ids failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("resource", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_resource = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Endpoint field resource failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("state", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Endpoint field state failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("technology", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_technology = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Endpoint field technology failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Endpoint has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_channel_ids) {
		ast_log(LOG_ERROR, "ARI Endpoint missing required field channel_ids\n");
		res = 0;
	}

	if (!has_resource) {
		ast_log(LOG_ERROR, "ARI Endpoint missing required field resource\n");
		res = 0;
	}

	if (!has_technology) {
		ast_log(LOG_ERROR, "ARI Endpoint missing required field technology\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_endpoint_fn(void)
{
	return ast_ari_validate_endpoint;
}

int ast_ari_validate_text_message(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_body = 0;
	int has_from = 0;
	int has_to = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("body", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_body = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessage field body failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("from", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_from = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessage field from failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("to", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_to = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessage field to failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("variables", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_object(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessage field variables failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI TextMessage has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_body) {
		ast_log(LOG_ERROR, "ARI TextMessage missing required field body\n");
		res = 0;
	}

	if (!has_from) {
		ast_log(LOG_ERROR, "ARI TextMessage missing required field from\n");
		res = 0;
	}

	if (!has_to) {
		ast_log(LOG_ERROR, "ARI TextMessage missing required field to\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_text_message_fn(void)
{
	return ast_ari_validate_text_message;
}

int ast_ari_validate_caller_id(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_name = 0;
	int has_number = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI CallerID field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("number", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_number = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI CallerID field number failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI CallerID has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI CallerID missing required field name\n");
		res = 0;
	}

	if (!has_number) {
		ast_log(LOG_ERROR, "ARI CallerID missing required field number\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_caller_id_fn(void)
{
	return ast_ari_validate_caller_id;
}

int ast_ari_validate_channel(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_accountcode = 0;
	int has_caller = 0;
	int has_connected = 0;
	int has_creationtime = 0;
	int has_dialplan = 0;
	int has_id = 0;
	int has_language = 0;
	int has_name = 0;
	int has_state = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("accountcode", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_accountcode = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field accountcode failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("caller", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_caller = 1;
			prop_is_valid = ast_ari_validate_caller_id(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field caller failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channelvars", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_object(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field channelvars failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("connected", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_connected = 1;
			prop_is_valid = ast_ari_validate_caller_id(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field connected failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("creationtime", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_creationtime = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field creationtime failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("dialplan", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_dialplan = 1;
			prop_is_valid = ast_ari_validate_dialplan_cep(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field dialplan failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_id = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("language", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_language = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field language failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("state", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_state = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field state failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("tenantid", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Channel field tenantid failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Channel has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_accountcode) {
		ast_log(LOG_ERROR, "ARI Channel missing required field accountcode\n");
		res = 0;
	}

	if (!has_caller) {
		ast_log(LOG_ERROR, "ARI Channel missing required field caller\n");
		res = 0;
	}

	if (!has_connected) {
		ast_log(LOG_ERROR, "ARI Channel missing required field connected\n");
		res = 0;
	}

	if (!has_creationtime) {
		ast_log(LOG_ERROR, "ARI Channel missing required field creationtime\n");
		res = 0;
	}

	if (!has_dialplan) {
		ast_log(LOG_ERROR, "ARI Channel missing required field dialplan\n");
		res = 0;
	}

	if (!has_id) {
		ast_log(LOG_ERROR, "ARI Channel missing required field id\n");
		res = 0;
	}

	if (!has_language) {
		ast_log(LOG_ERROR, "ARI Channel missing required field language\n");
		res = 0;
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI Channel missing required field name\n");
		res = 0;
	}

	if (!has_state) {
		ast_log(LOG_ERROR, "ARI Channel missing required field state\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_fn(void)
{
	return ast_ari_validate_channel;
}

int ast_ari_validate_dialed(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		{
			ast_log(LOG_ERROR,
				"ARI Dialed has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	return res;
}

ari_validator ast_ari_validate_dialed_fn(void)
{
	return ast_ari_validate_dialed;
}

int ast_ari_validate_dialplan_cep(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_app_data = 0;
	int has_app_name = 0;
	int has_context = 0;
	int has_exten = 0;
	int has_priority = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("app_data", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_app_data = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DialplanCEP field app_data failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("app_name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_app_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DialplanCEP field app_name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("context", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_context = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DialplanCEP field context failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("exten", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_exten = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DialplanCEP field exten failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("priority", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_priority = 1;
			prop_is_valid = ast_ari_validate_long(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DialplanCEP field priority failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI DialplanCEP has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_app_data) {
		ast_log(LOG_ERROR, "ARI DialplanCEP missing required field app_data\n");
		res = 0;
	}

	if (!has_app_name) {
		ast_log(LOG_ERROR, "ARI DialplanCEP missing required field app_name\n");
		res = 0;
	}

	if (!has_context) {
		ast_log(LOG_ERROR, "ARI DialplanCEP missing required field context\n");
		res = 0;
	}

	if (!has_exten) {
		ast_log(LOG_ERROR, "ARI DialplanCEP missing required field exten\n");
		res = 0;
	}

	if (!has_priority) {
		ast_log(LOG_ERROR, "ARI DialplanCEP missing required field priority\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_dialplan_cep_fn(void)
{
	return ast_ari_validate_dialplan_cep;
}

int ast_ari_validate_rtpstat(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_channel_uniqueid = 0;
	int has_local_ssrc = 0;
	int has_remote_ssrc = 0;
	int has_rxcount = 0;
	int has_rxoctetcount = 0;
	int has_rxploss = 0;
	int has_txcount = 0;
	int has_txoctetcount = 0;
	int has_txploss = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("channel_uniqueid", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel_uniqueid = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field channel_uniqueid failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_maxjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_maxjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_maxrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_maxrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_minjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_minjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_minrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_minrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_normdevjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_normdevjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_normdevrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_normdevrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_ssrc", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_local_ssrc = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_ssrc failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_stdevjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_stdevjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("local_stdevrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field local_stdevrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("maxrtt", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field maxrtt failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("minrtt", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field minrtt failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("normdevrtt", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field normdevrtt failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_maxjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_maxjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_maxrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_maxrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_minjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_minjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_minrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_minrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_normdevjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_normdevjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_normdevrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_normdevrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_ssrc", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_remote_ssrc = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_ssrc failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_stdevjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_stdevjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("remote_stdevrxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field remote_stdevrxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("rtt", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field rtt failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("rxcount", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_rxcount = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field rxcount failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("rxjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field rxjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("rxoctetcount", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_rxoctetcount = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field rxoctetcount failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("rxploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_rxploss = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field rxploss failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("stdevrtt", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field stdevrtt failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("txcount", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_txcount = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field txcount failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("txjitter", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_double(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field txjitter failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("txoctetcount", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_txoctetcount = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field txoctetcount failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("txploss", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_txploss = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RTPstat field txploss failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI RTPstat has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_channel_uniqueid) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field channel_uniqueid\n");
		res = 0;
	}

	if (!has_local_ssrc) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field local_ssrc\n");
		res = 0;
	}

	if (!has_remote_ssrc) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field remote_ssrc\n");
		res = 0;
	}

	if (!has_rxcount) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field rxcount\n");
		res = 0;
	}

	if (!has_rxoctetcount) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field rxoctetcount\n");
		res = 0;
	}

	if (!has_rxploss) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field rxploss\n");
		res = 0;
	}

	if (!has_txcount) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field txcount\n");
		res = 0;
	}

	if (!has_txoctetcount) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field txoctetcount\n");
		res = 0;
	}

	if (!has_txploss) {
		ast_log(LOG_ERROR, "ARI RTPstat missing required field txploss\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_rtpstat_fn(void)
{
	return ast_ari_validate_rtpstat;
}

int ast_ari_validate_bridge(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_bridge_class = 0;
	int has_bridge_type = 0;
	int has_channels = 0;
	int has_creationtime = 0;
	int has_creator = 0;
	int has_id = 0;
	int has_name = 0;
	int has_technology = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("bridge_class", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge_class = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field bridge_class failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge_type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field bridge_type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channels", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channels = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field channels failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("creationtime", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_creationtime = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field creationtime failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("creator", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_creator = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field creator failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_id = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("technology", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_technology = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field technology failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("video_mode", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field video_mode failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("video_source_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Bridge field video_source_id failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Bridge has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_bridge_class) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field bridge_class\n");
		res = 0;
	}

	if (!has_bridge_type) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field bridge_type\n");
		res = 0;
	}

	if (!has_channels) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field channels\n");
		res = 0;
	}

	if (!has_creationtime) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field creationtime\n");
		res = 0;
	}

	if (!has_creator) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field creator\n");
		res = 0;
	}

	if (!has_id) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field id\n");
		res = 0;
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field name\n");
		res = 0;
	}

	if (!has_technology) {
		ast_log(LOG_ERROR, "ARI Bridge missing required field technology\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_bridge_fn(void)
{
	return ast_ari_validate_bridge;
}

int ast_ari_validate_live_recording(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_format = 0;
	int has_name = 0;
	int has_state = 0;
	int has_target_uri = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("cause", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field cause failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("duration", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field duration failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("format", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_format = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field format failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("silence_duration", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field silence_duration failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("state", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_state = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field state failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("talking_duration", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field talking_duration failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("target_uri", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_target_uri = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI LiveRecording field target_uri failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI LiveRecording has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_format) {
		ast_log(LOG_ERROR, "ARI LiveRecording missing required field format\n");
		res = 0;
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI LiveRecording missing required field name\n");
		res = 0;
	}

	if (!has_state) {
		ast_log(LOG_ERROR, "ARI LiveRecording missing required field state\n");
		res = 0;
	}

	if (!has_target_uri) {
		ast_log(LOG_ERROR, "ARI LiveRecording missing required field target_uri\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_live_recording_fn(void)
{
	return ast_ari_validate_live_recording;
}

int ast_ari_validate_stored_recording(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_format = 0;
	int has_name = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("format", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_format = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StoredRecording field format failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StoredRecording field name failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI StoredRecording has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_format) {
		ast_log(LOG_ERROR, "ARI StoredRecording missing required field format\n");
		res = 0;
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI StoredRecording missing required field name\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_stored_recording_fn(void)
{
	return ast_ari_validate_stored_recording;
}

int ast_ari_validate_format_lang_pair(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_format = 0;
	int has_language = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("format", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_format = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI FormatLangPair field format failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("language", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_language = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI FormatLangPair field language failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI FormatLangPair has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_format) {
		ast_log(LOG_ERROR, "ARI FormatLangPair missing required field format\n");
		res = 0;
	}

	if (!has_language) {
		ast_log(LOG_ERROR, "ARI FormatLangPair missing required field language\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_format_lang_pair_fn(void)
{
	return ast_ari_validate_format_lang_pair;
}

int ast_ari_validate_sound(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_formats = 0;
	int has_id = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("formats", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_formats = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_format_lang_pair);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Sound field formats failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_id = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Sound field id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("text", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Sound field text failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Sound has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_formats) {
		ast_log(LOG_ERROR, "ARI Sound missing required field formats\n");
		res = 0;
	}

	if (!has_id) {
		ast_log(LOG_ERROR, "ARI Sound missing required field id\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_sound_fn(void)
{
	return ast_ari_validate_sound;
}

int ast_ari_validate_playback(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_id = 0;
	int has_media_uri = 0;
	int has_state = 0;
	int has_target_uri = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_id = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Playback field id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("language", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Playback field language failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("media_uri", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_media_uri = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Playback field media_uri failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("next_media_uri", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Playback field next_media_uri failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("state", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_state = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Playback field state failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("target_uri", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_target_uri = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Playback field target_uri failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Playback has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_id) {
		ast_log(LOG_ERROR, "ARI Playback missing required field id\n");
		res = 0;
	}

	if (!has_media_uri) {
		ast_log(LOG_ERROR, "ARI Playback missing required field media_uri\n");
		res = 0;
	}

	if (!has_state) {
		ast_log(LOG_ERROR, "ARI Playback missing required field state\n");
		res = 0;
	}

	if (!has_target_uri) {
		ast_log(LOG_ERROR, "ARI Playback missing required field target_uri\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_playback_fn(void)
{
	return ast_ari_validate_playback;
}

int ast_ari_validate_device_state(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_name = 0;
	int has_state = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DeviceState field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("state", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_state = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DeviceState field state failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI DeviceState has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI DeviceState missing required field name\n");
		res = 0;
	}

	if (!has_state) {
		ast_log(LOG_ERROR, "ARI DeviceState missing required field state\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_device_state_fn(void)
{
	return ast_ari_validate_device_state;
}

int ast_ari_validate_mailbox(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_name = 0;
	int has_new_messages = 0;
	int has_old_messages = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Mailbox field name failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("new_messages", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_new_messages = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Mailbox field new_messages failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("old_messages", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_old_messages = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Mailbox field old_messages failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Mailbox has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI Mailbox missing required field name\n");
		res = 0;
	}

	if (!has_new_messages) {
		ast_log(LOG_ERROR, "ARI Mailbox missing required field new_messages\n");
		res = 0;
	}

	if (!has_old_messages) {
		ast_log(LOG_ERROR, "ARI Mailbox missing required field old_messages\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_mailbox_fn(void)
{
	return ast_ari_validate_mailbox;
}

int ast_ari_validate_application_move_failed(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_args = 0;
	int has_channel = 0;
	int has_destination = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationMoveFailed field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationMoveFailed field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationMoveFailed field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationMoveFailed field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("args", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_args = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationMoveFailed field args failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationMoveFailed field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_destination = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationMoveFailed field destination failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ApplicationMoveFailed has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ApplicationMoveFailed missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ApplicationMoveFailed missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ApplicationMoveFailed missing required field timestamp\n");
		res = 0;
	}

	if (!has_args) {
		ast_log(LOG_ERROR, "ARI ApplicationMoveFailed missing required field args\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ApplicationMoveFailed missing required field channel\n");
		res = 0;
	}

	if (!has_destination) {
		ast_log(LOG_ERROR, "ARI ApplicationMoveFailed missing required field destination\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_application_move_failed_fn(void)
{
	return ast_ari_validate_application_move_failed;
}

int ast_ari_validate_application_replaced(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationReplaced field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationReplaced field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationReplaced field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ApplicationReplaced field timestamp failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ApplicationReplaced has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ApplicationReplaced missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ApplicationReplaced missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ApplicationReplaced missing required field timestamp\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_application_replaced_fn(void)
{
	return ast_ari_validate_application_replaced;
}

int ast_ari_validate_bridge_attended_transfer(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_destination_type = 0;
	int has_is_external = 0;
	int has_result = 0;
	int has_transferer_first_leg = 0;
	int has_transferer_second_leg = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination_application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field destination_application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination_bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field destination_bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination_link_first_leg", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field destination_link_first_leg failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination_link_second_leg", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field destination_link_second_leg failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination_threeway_bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field destination_threeway_bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination_threeway_channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field destination_threeway_channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("destination_type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_destination_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field destination_type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("is_external", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_is_external = 1;
			prop_is_valid = ast_ari_validate_boolean(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field is_external failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("replace_channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field replace_channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("result", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_result = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field result failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("transfer_target", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field transfer_target failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("transferee", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field transferee failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("transferer_first_leg", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_transferer_first_leg = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field transferer_first_leg failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("transferer_first_leg_bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field transferer_first_leg_bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("transferer_second_leg", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_transferer_second_leg = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field transferer_second_leg failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("transferer_second_leg_bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer field transferer_second_leg_bridge failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI BridgeAttendedTransfer has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field timestamp\n");
		res = 0;
	}

	if (!has_destination_type) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field destination_type\n");
		res = 0;
	}

	if (!has_is_external) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field is_external\n");
		res = 0;
	}

	if (!has_result) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field result\n");
		res = 0;
	}

	if (!has_transferer_first_leg) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field transferer_first_leg\n");
		res = 0;
	}

	if (!has_transferer_second_leg) {
		ast_log(LOG_ERROR, "ARI BridgeAttendedTransfer missing required field transferer_second_leg\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_bridge_attended_transfer_fn(void)
{
	return ast_ari_validate_bridge_attended_transfer;
}

int ast_ari_validate_bridge_blind_transfer(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;
	int has_context = 0;
	int has_exten = 0;
	int has_is_external = 0;
	int has_result = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("context", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_context = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field context failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("exten", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_exten = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field exten failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("is_external", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_is_external = 1;
			prop_is_valid = ast_ari_validate_boolean(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field is_external failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("replace_channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field replace_channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("result", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_result = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field result failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("transferee", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeBlindTransfer field transferee failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI BridgeBlindTransfer has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field channel\n");
		res = 0;
	}

	if (!has_context) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field context\n");
		res = 0;
	}

	if (!has_exten) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field exten\n");
		res = 0;
	}

	if (!has_is_external) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field is_external\n");
		res = 0;
	}

	if (!has_result) {
		ast_log(LOG_ERROR, "ARI BridgeBlindTransfer missing required field result\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_bridge_blind_transfer_fn(void)
{
	return ast_ari_validate_bridge_blind_transfer;
}

int ast_ari_validate_bridge_created(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_bridge = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeCreated field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeCreated field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeCreated field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeCreated field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge = 1;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeCreated field bridge failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI BridgeCreated has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI BridgeCreated missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI BridgeCreated missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI BridgeCreated missing required field timestamp\n");
		res = 0;
	}

	if (!has_bridge) {
		ast_log(LOG_ERROR, "ARI BridgeCreated missing required field bridge\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_bridge_created_fn(void)
{
	return ast_ari_validate_bridge_created;
}

int ast_ari_validate_bridge_destroyed(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_bridge = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeDestroyed field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeDestroyed field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeDestroyed field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeDestroyed field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge = 1;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeDestroyed field bridge failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI BridgeDestroyed has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI BridgeDestroyed missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI BridgeDestroyed missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI BridgeDestroyed missing required field timestamp\n");
		res = 0;
	}

	if (!has_bridge) {
		ast_log(LOG_ERROR, "ARI BridgeDestroyed missing required field bridge\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_bridge_destroyed_fn(void)
{
	return ast_ari_validate_bridge_destroyed;
}

int ast_ari_validate_bridge_merged(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_bridge = 0;
	int has_bridge_from = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeMerged field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeMerged field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeMerged field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeMerged field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge = 1;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeMerged field bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge_from", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge_from = 1;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeMerged field bridge_from failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI BridgeMerged has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI BridgeMerged missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI BridgeMerged missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI BridgeMerged missing required field timestamp\n");
		res = 0;
	}

	if (!has_bridge) {
		ast_log(LOG_ERROR, "ARI BridgeMerged missing required field bridge\n");
		res = 0;
	}

	if (!has_bridge_from) {
		ast_log(LOG_ERROR, "ARI BridgeMerged missing required field bridge_from\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_bridge_merged_fn(void)
{
	return ast_ari_validate_bridge_merged;
}

int ast_ari_validate_bridge_video_source_changed(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_bridge = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge = 1;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged field bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("old_video_source_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged field old_video_source_id failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI BridgeVideoSourceChanged has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged missing required field timestamp\n");
		res = 0;
	}

	if (!has_bridge) {
		ast_log(LOG_ERROR, "ARI BridgeVideoSourceChanged missing required field bridge\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_bridge_video_source_changed_fn(void)
{
	return ast_ari_validate_bridge_video_source_changed;
}

int ast_ari_validate_channel_caller_id(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_caller_presentation = 0;
	int has_caller_presentation_txt = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCallerId field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCallerId field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCallerId field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCallerId field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("caller_presentation", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_caller_presentation = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCallerId field caller_presentation failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("caller_presentation_txt", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_caller_presentation_txt = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCallerId field caller_presentation_txt failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCallerId field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelCallerId has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelCallerId missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelCallerId missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelCallerId missing required field timestamp\n");
		res = 0;
	}

	if (!has_caller_presentation) {
		ast_log(LOG_ERROR, "ARI ChannelCallerId missing required field caller_presentation\n");
		res = 0;
	}

	if (!has_caller_presentation_txt) {
		ast_log(LOG_ERROR, "ARI ChannelCallerId missing required field caller_presentation_txt\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelCallerId missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_caller_id_fn(void)
{
	return ast_ari_validate_channel_caller_id;
}

int ast_ari_validate_channel_connected_line(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelConnectedLine field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelConnectedLine field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelConnectedLine field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelConnectedLine field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelConnectedLine field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelConnectedLine has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelConnectedLine missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelConnectedLine missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelConnectedLine missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelConnectedLine missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_connected_line_fn(void)
{
	return ast_ari_validate_channel_connected_line;
}

int ast_ari_validate_channel_created(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCreated field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCreated field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCreated field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCreated field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelCreated field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelCreated has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelCreated missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelCreated missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelCreated missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelCreated missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_created_fn(void)
{
	return ast_ari_validate_channel_created;
}

int ast_ari_validate_channel_destroyed(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_cause = 0;
	int has_cause_txt = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDestroyed field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDestroyed field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDestroyed field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDestroyed field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("cause", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_cause = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDestroyed field cause failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("cause_txt", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_cause_txt = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDestroyed field cause_txt failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDestroyed field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelDestroyed has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelDestroyed missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelDestroyed missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelDestroyed missing required field timestamp\n");
		res = 0;
	}

	if (!has_cause) {
		ast_log(LOG_ERROR, "ARI ChannelDestroyed missing required field cause\n");
		res = 0;
	}

	if (!has_cause_txt) {
		ast_log(LOG_ERROR, "ARI ChannelDestroyed missing required field cause_txt\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelDestroyed missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_destroyed_fn(void)
{
	return ast_ari_validate_channel_destroyed;
}

int ast_ari_validate_channel_dialplan(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;
	int has_dialplan_app = 0;
	int has_dialplan_app_data = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDialplan field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDialplan field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDialplan field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDialplan field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDialplan field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("dialplan_app", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_dialplan_app = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDialplan field dialplan_app failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("dialplan_app_data", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_dialplan_app_data = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDialplan field dialplan_app_data failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelDialplan has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelDialplan missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelDialplan missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelDialplan missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelDialplan missing required field channel\n");
		res = 0;
	}

	if (!has_dialplan_app) {
		ast_log(LOG_ERROR, "ARI ChannelDialplan missing required field dialplan_app\n");
		res = 0;
	}

	if (!has_dialplan_app_data) {
		ast_log(LOG_ERROR, "ARI ChannelDialplan missing required field dialplan_app_data\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_dialplan_fn(void)
{
	return ast_ari_validate_channel_dialplan;
}

int ast_ari_validate_channel_dtmf_received(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;
	int has_digit = 0;
	int has_duration_ms = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDtmfReceived field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDtmfReceived field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDtmfReceived field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDtmfReceived field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDtmfReceived field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("digit", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_digit = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDtmfReceived field digit failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("duration_ms", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_duration_ms = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelDtmfReceived field duration_ms failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelDtmfReceived has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelDtmfReceived missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelDtmfReceived missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelDtmfReceived missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelDtmfReceived missing required field channel\n");
		res = 0;
	}

	if (!has_digit) {
		ast_log(LOG_ERROR, "ARI ChannelDtmfReceived missing required field digit\n");
		res = 0;
	}

	if (!has_duration_ms) {
		ast_log(LOG_ERROR, "ARI ChannelDtmfReceived missing required field duration_ms\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_dtmf_received_fn(void)
{
	return ast_ari_validate_channel_dtmf_received;
}

int ast_ari_validate_channel_entered_bridge(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_bridge = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelEnteredBridge field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelEnteredBridge field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelEnteredBridge field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelEnteredBridge field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge = 1;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelEnteredBridge field bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelEnteredBridge field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelEnteredBridge has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelEnteredBridge missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelEnteredBridge missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelEnteredBridge missing required field timestamp\n");
		res = 0;
	}

	if (!has_bridge) {
		ast_log(LOG_ERROR, "ARI ChannelEnteredBridge missing required field bridge\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_entered_bridge_fn(void)
{
	return ast_ari_validate_channel_entered_bridge;
}

int ast_ari_validate_channel_hangup_request(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHangupRequest field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHangupRequest field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHangupRequest field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHangupRequest field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("cause", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHangupRequest field cause failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHangupRequest field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("soft", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_boolean(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHangupRequest field soft failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelHangupRequest has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelHangupRequest missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelHangupRequest missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelHangupRequest missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelHangupRequest missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_hangup_request_fn(void)
{
	return ast_ari_validate_channel_hangup_request;
}

int ast_ari_validate_channel_hold(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHold field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHold field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHold field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHold field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHold field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("musicclass", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelHold field musicclass failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelHold has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelHold missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelHold missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelHold missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelHold missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_hold_fn(void)
{
	return ast_ari_validate_channel_hold;
}

int ast_ari_validate_channel_left_bridge(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_bridge = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelLeftBridge field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelLeftBridge field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelLeftBridge field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelLeftBridge field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge = 1;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelLeftBridge field bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelLeftBridge field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelLeftBridge has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelLeftBridge missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelLeftBridge missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelLeftBridge missing required field timestamp\n");
		res = 0;
	}

	if (!has_bridge) {
		ast_log(LOG_ERROR, "ARI ChannelLeftBridge missing required field bridge\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelLeftBridge missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_left_bridge_fn(void)
{
	return ast_ari_validate_channel_left_bridge;
}

int ast_ari_validate_channel_state_change(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelStateChange field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelStateChange field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelStateChange field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelStateChange field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelStateChange field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelStateChange has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelStateChange missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelStateChange missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelStateChange missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelStateChange missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_state_change_fn(void)
{
	return ast_ari_validate_channel_state_change;
}

int ast_ari_validate_channel_talking_finished(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;
	int has_duration = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingFinished field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingFinished field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingFinished field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingFinished field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingFinished field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("duration", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_duration = 1;
			prop_is_valid = ast_ari_validate_int(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingFinished field duration failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelTalkingFinished has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingFinished missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingFinished missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingFinished missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingFinished missing required field channel\n");
		res = 0;
	}

	if (!has_duration) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingFinished missing required field duration\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_talking_finished_fn(void)
{
	return ast_ari_validate_channel_talking_finished;
}

int ast_ari_validate_channel_talking_started(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingStarted field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingStarted field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingStarted field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingStarted field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelTalkingStarted field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelTalkingStarted has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingStarted missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingStarted missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingStarted missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelTalkingStarted missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_talking_started_fn(void)
{
	return ast_ari_validate_channel_talking_started;
}

int ast_ari_validate_channel_unhold(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUnhold field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUnhold field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUnhold field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUnhold field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUnhold field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelUnhold has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelUnhold missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelUnhold missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelUnhold missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI ChannelUnhold missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_unhold_fn(void)
{
	return ast_ari_validate_channel_unhold;
}

int ast_ari_validate_channel_userevent(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_eventname = 0;
	int has_userevent = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("bridge", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_bridge(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field bridge failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("endpoint", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_endpoint(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field endpoint failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("eventname", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_eventname = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field eventname failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("userevent", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_userevent = 1;
			prop_is_valid = ast_ari_validate_object(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelUserevent field userevent failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelUserevent has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelUserevent missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelUserevent missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelUserevent missing required field timestamp\n");
		res = 0;
	}

	if (!has_eventname) {
		ast_log(LOG_ERROR, "ARI ChannelUserevent missing required field eventname\n");
		res = 0;
	}

	if (!has_userevent) {
		ast_log(LOG_ERROR, "ARI ChannelUserevent missing required field userevent\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_userevent_fn(void)
{
	return ast_ari_validate_channel_userevent;
}

int ast_ari_validate_channel_varset(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_value = 0;
	int has_variable = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelVarset field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelVarset field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelVarset field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelVarset field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelVarset field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("value", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_value = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelVarset field value failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("variable", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_variable = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ChannelVarset field variable failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ChannelVarset has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ChannelVarset missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ChannelVarset missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ChannelVarset missing required field timestamp\n");
		res = 0;
	}

	if (!has_value) {
		ast_log(LOG_ERROR, "ARI ChannelVarset missing required field value\n");
		res = 0;
	}

	if (!has_variable) {
		ast_log(LOG_ERROR, "ARI ChannelVarset missing required field variable\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_channel_varset_fn(void)
{
	return ast_ari_validate_channel_varset;
}

int ast_ari_validate_contact_info(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_aor = 0;
	int has_contact_status = 0;
	int has_uri = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("aor", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_aor = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactInfo field aor failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("contact_status", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_contact_status = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactInfo field contact_status failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("roundtrip_usec", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactInfo field roundtrip_usec failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("uri", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_uri = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactInfo field uri failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ContactInfo has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_aor) {
		ast_log(LOG_ERROR, "ARI ContactInfo missing required field aor\n");
		res = 0;
	}

	if (!has_contact_status) {
		ast_log(LOG_ERROR, "ARI ContactInfo missing required field contact_status\n");
		res = 0;
	}

	if (!has_uri) {
		ast_log(LOG_ERROR, "ARI ContactInfo missing required field uri\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_contact_info_fn(void)
{
	return ast_ari_validate_contact_info;
}

int ast_ari_validate_contact_status_change(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_contact_info = 0;
	int has_endpoint = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactStatusChange field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactStatusChange field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactStatusChange field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactStatusChange field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("contact_info", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_contact_info = 1;
			prop_is_valid = ast_ari_validate_contact_info(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactStatusChange field contact_info failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("endpoint", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_endpoint = 1;
			prop_is_valid = ast_ari_validate_endpoint(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI ContactStatusChange field endpoint failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI ContactStatusChange has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI ContactStatusChange missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI ContactStatusChange missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI ContactStatusChange missing required field timestamp\n");
		res = 0;
	}

	if (!has_contact_info) {
		ast_log(LOG_ERROR, "ARI ContactStatusChange missing required field contact_info\n");
		res = 0;
	}

	if (!has_endpoint) {
		ast_log(LOG_ERROR, "ARI ContactStatusChange missing required field endpoint\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_contact_status_change_fn(void)
{
	return ast_ari_validate_contact_status_change;
}

int ast_ari_validate_device_state_changed(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_device_state = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DeviceStateChanged field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DeviceStateChanged field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DeviceStateChanged field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DeviceStateChanged field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("device_state", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_device_state = 1;
			prop_is_valid = ast_ari_validate_device_state(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI DeviceStateChanged field device_state failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI DeviceStateChanged has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI DeviceStateChanged missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI DeviceStateChanged missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI DeviceStateChanged missing required field timestamp\n");
		res = 0;
	}

	if (!has_device_state) {
		ast_log(LOG_ERROR, "ARI DeviceStateChanged missing required field device_state\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_device_state_changed_fn(void)
{
	return ast_ari_validate_device_state_changed;
}

int ast_ari_validate_dial(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_dialstatus = 0;
	int has_peer = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("caller", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field caller failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("dialstatus", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_dialstatus = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field dialstatus failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("dialstring", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field dialstring failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("forward", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field forward failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("forwarded", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field forwarded failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("peer", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_peer = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Dial field peer failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Dial has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI Dial missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI Dial missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI Dial missing required field timestamp\n");
		res = 0;
	}

	if (!has_dialstatus) {
		ast_log(LOG_ERROR, "ARI Dial missing required field dialstatus\n");
		res = 0;
	}

	if (!has_peer) {
		ast_log(LOG_ERROR, "ARI Dial missing required field peer\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_dial_fn(void)
{
	return ast_ari_validate_dial;
}

int ast_ari_validate_endpoint_state_change(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_endpoint = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI EndpointStateChange field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI EndpointStateChange field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI EndpointStateChange field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI EndpointStateChange field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("endpoint", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_endpoint = 1;
			prop_is_valid = ast_ari_validate_endpoint(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI EndpointStateChange field endpoint failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI EndpointStateChange has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI EndpointStateChange missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI EndpointStateChange missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI EndpointStateChange missing required field timestamp\n");
		res = 0;
	}

	if (!has_endpoint) {
		ast_log(LOG_ERROR, "ARI EndpointStateChange missing required field endpoint\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_endpoint_state_change_fn(void)
{
	return ast_ari_validate_endpoint_state_change;
}

int ast_ari_validate_event(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	const char *discriminator;

	discriminator = ast_json_string_get(ast_json_object_get(json, "type"));
	if (!discriminator) {
		ast_log(LOG_ERROR, "ARI Event missing required field type\n");
		return 0;
	}

	if (strcmp("Event", discriminator) == 0) {
		/* Self type; fall through */
	} else
	if (strcmp("ApplicationMoveFailed", discriminator) == 0) {
		return ast_ari_validate_application_move_failed(json);
	} else
	if (strcmp("ApplicationReplaced", discriminator) == 0) {
		return ast_ari_validate_application_replaced(json);
	} else
	if (strcmp("BridgeAttendedTransfer", discriminator) == 0) {
		return ast_ari_validate_bridge_attended_transfer(json);
	} else
	if (strcmp("BridgeBlindTransfer", discriminator) == 0) {
		return ast_ari_validate_bridge_blind_transfer(json);
	} else
	if (strcmp("BridgeCreated", discriminator) == 0) {
		return ast_ari_validate_bridge_created(json);
	} else
	if (strcmp("BridgeDestroyed", discriminator) == 0) {
		return ast_ari_validate_bridge_destroyed(json);
	} else
	if (strcmp("BridgeMerged", discriminator) == 0) {
		return ast_ari_validate_bridge_merged(json);
	} else
	if (strcmp("BridgeVideoSourceChanged", discriminator) == 0) {
		return ast_ari_validate_bridge_video_source_changed(json);
	} else
	if (strcmp("ChannelCallerId", discriminator) == 0) {
		return ast_ari_validate_channel_caller_id(json);
	} else
	if (strcmp("ChannelConnectedLine", discriminator) == 0) {
		return ast_ari_validate_channel_connected_line(json);
	} else
	if (strcmp("ChannelCreated", discriminator) == 0) {
		return ast_ari_validate_channel_created(json);
	} else
	if (strcmp("ChannelDestroyed", discriminator) == 0) {
		return ast_ari_validate_channel_destroyed(json);
	} else
	if (strcmp("ChannelDialplan", discriminator) == 0) {
		return ast_ari_validate_channel_dialplan(json);
	} else
	if (strcmp("ChannelDtmfReceived", discriminator) == 0) {
		return ast_ari_validate_channel_dtmf_received(json);
	} else
	if (strcmp("ChannelEnteredBridge", discriminator) == 0) {
		return ast_ari_validate_channel_entered_bridge(json);
	} else
	if (strcmp("ChannelHangupRequest", discriminator) == 0) {
		return ast_ari_validate_channel_hangup_request(json);
	} else
	if (strcmp("ChannelHold", discriminator) == 0) {
		return ast_ari_validate_channel_hold(json);
	} else
	if (strcmp("ChannelLeftBridge", discriminator) == 0) {
		return ast_ari_validate_channel_left_bridge(json);
	} else
	if (strcmp("ChannelStateChange", discriminator) == 0) {
		return ast_ari_validate_channel_state_change(json);
	} else
	if (strcmp("ChannelTalkingFinished", discriminator) == 0) {
		return ast_ari_validate_channel_talking_finished(json);
	} else
	if (strcmp("ChannelTalkingStarted", discriminator) == 0) {
		return ast_ari_validate_channel_talking_started(json);
	} else
	if (strcmp("ChannelUnhold", discriminator) == 0) {
		return ast_ari_validate_channel_unhold(json);
	} else
	if (strcmp("ChannelUserevent", discriminator) == 0) {
		return ast_ari_validate_channel_userevent(json);
	} else
	if (strcmp("ChannelVarset", discriminator) == 0) {
		return ast_ari_validate_channel_varset(json);
	} else
	if (strcmp("ContactStatusChange", discriminator) == 0) {
		return ast_ari_validate_contact_status_change(json);
	} else
	if (strcmp("DeviceStateChanged", discriminator) == 0) {
		return ast_ari_validate_device_state_changed(json);
	} else
	if (strcmp("Dial", discriminator) == 0) {
		return ast_ari_validate_dial(json);
	} else
	if (strcmp("EndpointStateChange", discriminator) == 0) {
		return ast_ari_validate_endpoint_state_change(json);
	} else
	if (strcmp("PeerStatusChange", discriminator) == 0) {
		return ast_ari_validate_peer_status_change(json);
	} else
	if (strcmp("PlaybackContinuing", discriminator) == 0) {
		return ast_ari_validate_playback_continuing(json);
	} else
	if (strcmp("PlaybackFinished", discriminator) == 0) {
		return ast_ari_validate_playback_finished(json);
	} else
	if (strcmp("PlaybackStarted", discriminator) == 0) {
		return ast_ari_validate_playback_started(json);
	} else
	if (strcmp("RecordingFailed", discriminator) == 0) {
		return ast_ari_validate_recording_failed(json);
	} else
	if (strcmp("RecordingFinished", discriminator) == 0) {
		return ast_ari_validate_recording_finished(json);
	} else
	if (strcmp("RecordingStarted", discriminator) == 0) {
		return ast_ari_validate_recording_started(json);
	} else
	if (strcmp("StasisEnd", discriminator) == 0) {
		return ast_ari_validate_stasis_end(json);
	} else
	if (strcmp("StasisStart", discriminator) == 0) {
		return ast_ari_validate_stasis_start(json);
	} else
	if (strcmp("TextMessageReceived", discriminator) == 0) {
		return ast_ari_validate_text_message_received(json);
	} else
	{
		ast_log(LOG_ERROR, "ARI Event has undocumented subtype %s\n",
			discriminator);
		res = 0;
	}

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Event field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Event field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Event field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Event field timestamp failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Event has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI Event missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI Event missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI Event missing required field timestamp\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_event_fn(void)
{
	return ast_ari_validate_event;
}

int ast_ari_validate_message(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	const char *discriminator;

	discriminator = ast_json_string_get(ast_json_object_get(json, "type"));
	if (!discriminator) {
		ast_log(LOG_ERROR, "ARI Message missing required field type\n");
		return 0;
	}

	if (strcmp("Message", discriminator) == 0) {
		/* Self type; fall through */
	} else
	if (strcmp("ApplicationMoveFailed", discriminator) == 0) {
		return ast_ari_validate_application_move_failed(json);
	} else
	if (strcmp("ApplicationReplaced", discriminator) == 0) {
		return ast_ari_validate_application_replaced(json);
	} else
	if (strcmp("BridgeAttendedTransfer", discriminator) == 0) {
		return ast_ari_validate_bridge_attended_transfer(json);
	} else
	if (strcmp("BridgeBlindTransfer", discriminator) == 0) {
		return ast_ari_validate_bridge_blind_transfer(json);
	} else
	if (strcmp("BridgeCreated", discriminator) == 0) {
		return ast_ari_validate_bridge_created(json);
	} else
	if (strcmp("BridgeDestroyed", discriminator) == 0) {
		return ast_ari_validate_bridge_destroyed(json);
	} else
	if (strcmp("BridgeMerged", discriminator) == 0) {
		return ast_ari_validate_bridge_merged(json);
	} else
	if (strcmp("BridgeVideoSourceChanged", discriminator) == 0) {
		return ast_ari_validate_bridge_video_source_changed(json);
	} else
	if (strcmp("ChannelCallerId", discriminator) == 0) {
		return ast_ari_validate_channel_caller_id(json);
	} else
	if (strcmp("ChannelConnectedLine", discriminator) == 0) {
		return ast_ari_validate_channel_connected_line(json);
	} else
	if (strcmp("ChannelCreated", discriminator) == 0) {
		return ast_ari_validate_channel_created(json);
	} else
	if (strcmp("ChannelDestroyed", discriminator) == 0) {
		return ast_ari_validate_channel_destroyed(json);
	} else
	if (strcmp("ChannelDialplan", discriminator) == 0) {
		return ast_ari_validate_channel_dialplan(json);
	} else
	if (strcmp("ChannelDtmfReceived", discriminator) == 0) {
		return ast_ari_validate_channel_dtmf_received(json);
	} else
	if (strcmp("ChannelEnteredBridge", discriminator) == 0) {
		return ast_ari_validate_channel_entered_bridge(json);
	} else
	if (strcmp("ChannelHangupRequest", discriminator) == 0) {
		return ast_ari_validate_channel_hangup_request(json);
	} else
	if (strcmp("ChannelHold", discriminator) == 0) {
		return ast_ari_validate_channel_hold(json);
	} else
	if (strcmp("ChannelLeftBridge", discriminator) == 0) {
		return ast_ari_validate_channel_left_bridge(json);
	} else
	if (strcmp("ChannelStateChange", discriminator) == 0) {
		return ast_ari_validate_channel_state_change(json);
	} else
	if (strcmp("ChannelTalkingFinished", discriminator) == 0) {
		return ast_ari_validate_channel_talking_finished(json);
	} else
	if (strcmp("ChannelTalkingStarted", discriminator) == 0) {
		return ast_ari_validate_channel_talking_started(json);
	} else
	if (strcmp("ChannelUnhold", discriminator) == 0) {
		return ast_ari_validate_channel_unhold(json);
	} else
	if (strcmp("ChannelUserevent", discriminator) == 0) {
		return ast_ari_validate_channel_userevent(json);
	} else
	if (strcmp("ChannelVarset", discriminator) == 0) {
		return ast_ari_validate_channel_varset(json);
	} else
	if (strcmp("ContactStatusChange", discriminator) == 0) {
		return ast_ari_validate_contact_status_change(json);
	} else
	if (strcmp("DeviceStateChanged", discriminator) == 0) {
		return ast_ari_validate_device_state_changed(json);
	} else
	if (strcmp("Dial", discriminator) == 0) {
		return ast_ari_validate_dial(json);
	} else
	if (strcmp("EndpointStateChange", discriminator) == 0) {
		return ast_ari_validate_endpoint_state_change(json);
	} else
	if (strcmp("Event", discriminator) == 0) {
		return ast_ari_validate_event(json);
	} else
	if (strcmp("MissingParams", discriminator) == 0) {
		return ast_ari_validate_missing_params(json);
	} else
	if (strcmp("PeerStatusChange", discriminator) == 0) {
		return ast_ari_validate_peer_status_change(json);
	} else
	if (strcmp("PlaybackContinuing", discriminator) == 0) {
		return ast_ari_validate_playback_continuing(json);
	} else
	if (strcmp("PlaybackFinished", discriminator) == 0) {
		return ast_ari_validate_playback_finished(json);
	} else
	if (strcmp("PlaybackStarted", discriminator) == 0) {
		return ast_ari_validate_playback_started(json);
	} else
	if (strcmp("RecordingFailed", discriminator) == 0) {
		return ast_ari_validate_recording_failed(json);
	} else
	if (strcmp("RecordingFinished", discriminator) == 0) {
		return ast_ari_validate_recording_finished(json);
	} else
	if (strcmp("RecordingStarted", discriminator) == 0) {
		return ast_ari_validate_recording_started(json);
	} else
	if (strcmp("StasisEnd", discriminator) == 0) {
		return ast_ari_validate_stasis_end(json);
	} else
	if (strcmp("StasisStart", discriminator) == 0) {
		return ast_ari_validate_stasis_start(json);
	} else
	if (strcmp("TextMessageReceived", discriminator) == 0) {
		return ast_ari_validate_text_message_received(json);
	} else
	{
		ast_log(LOG_ERROR, "ARI Message has undocumented subtype %s\n",
			discriminator);
		res = 0;
	}

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Message field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Message field type failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Message has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI Message missing required field type\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_message_fn(void)
{
	return ast_ari_validate_message;
}

int ast_ari_validate_missing_params(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_params = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI MissingParams field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI MissingParams field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("params", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_params = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI MissingParams field params failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI MissingParams has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI MissingParams missing required field type\n");
		res = 0;
	}

	if (!has_params) {
		ast_log(LOG_ERROR, "ARI MissingParams missing required field params\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_missing_params_fn(void)
{
	return ast_ari_validate_missing_params;
}

int ast_ari_validate_peer(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_peer_status = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("address", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Peer field address failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("cause", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Peer field cause failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("peer_status", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_peer_status = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Peer field peer_status failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("port", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Peer field port failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("time", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Peer field time failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Peer has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_peer_status) {
		ast_log(LOG_ERROR, "ARI Peer missing required field peer_status\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_peer_fn(void)
{
	return ast_ari_validate_peer;
}

int ast_ari_validate_peer_status_change(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_endpoint = 0;
	int has_peer = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PeerStatusChange field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PeerStatusChange field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PeerStatusChange field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PeerStatusChange field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("endpoint", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_endpoint = 1;
			prop_is_valid = ast_ari_validate_endpoint(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PeerStatusChange field endpoint failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("peer", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_peer = 1;
			prop_is_valid = ast_ari_validate_peer(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PeerStatusChange field peer failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI PeerStatusChange has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI PeerStatusChange missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI PeerStatusChange missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI PeerStatusChange missing required field timestamp\n");
		res = 0;
	}

	if (!has_endpoint) {
		ast_log(LOG_ERROR, "ARI PeerStatusChange missing required field endpoint\n");
		res = 0;
	}

	if (!has_peer) {
		ast_log(LOG_ERROR, "ARI PeerStatusChange missing required field peer\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_peer_status_change_fn(void)
{
	return ast_ari_validate_peer_status_change;
}

int ast_ari_validate_playback_continuing(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_playback = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackContinuing field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackContinuing field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackContinuing field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackContinuing field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("playback", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_playback = 1;
			prop_is_valid = ast_ari_validate_playback(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackContinuing field playback failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI PlaybackContinuing has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI PlaybackContinuing missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI PlaybackContinuing missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI PlaybackContinuing missing required field timestamp\n");
		res = 0;
	}

	if (!has_playback) {
		ast_log(LOG_ERROR, "ARI PlaybackContinuing missing required field playback\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_playback_continuing_fn(void)
{
	return ast_ari_validate_playback_continuing;
}

int ast_ari_validate_playback_finished(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_playback = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackFinished field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackFinished field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackFinished field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackFinished field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("playback", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_playback = 1;
			prop_is_valid = ast_ari_validate_playback(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackFinished field playback failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI PlaybackFinished has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI PlaybackFinished missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI PlaybackFinished missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI PlaybackFinished missing required field timestamp\n");
		res = 0;
	}

	if (!has_playback) {
		ast_log(LOG_ERROR, "ARI PlaybackFinished missing required field playback\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_playback_finished_fn(void)
{
	return ast_ari_validate_playback_finished;
}

int ast_ari_validate_playback_started(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_playback = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackStarted field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackStarted field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackStarted field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackStarted field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("playback", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_playback = 1;
			prop_is_valid = ast_ari_validate_playback(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI PlaybackStarted field playback failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI PlaybackStarted has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI PlaybackStarted missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI PlaybackStarted missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI PlaybackStarted missing required field timestamp\n");
		res = 0;
	}

	if (!has_playback) {
		ast_log(LOG_ERROR, "ARI PlaybackStarted missing required field playback\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_playback_started_fn(void)
{
	return ast_ari_validate_playback_started;
}

int ast_ari_validate_recording_failed(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_recording = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFailed field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFailed field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFailed field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFailed field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("recording", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_recording = 1;
			prop_is_valid = ast_ari_validate_live_recording(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFailed field recording failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI RecordingFailed has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI RecordingFailed missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI RecordingFailed missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI RecordingFailed missing required field timestamp\n");
		res = 0;
	}

	if (!has_recording) {
		ast_log(LOG_ERROR, "ARI RecordingFailed missing required field recording\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_recording_failed_fn(void)
{
	return ast_ari_validate_recording_failed;
}

int ast_ari_validate_recording_finished(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_recording = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFinished field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFinished field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFinished field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFinished field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("recording", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_recording = 1;
			prop_is_valid = ast_ari_validate_live_recording(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingFinished field recording failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI RecordingFinished has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI RecordingFinished missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI RecordingFinished missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI RecordingFinished missing required field timestamp\n");
		res = 0;
	}

	if (!has_recording) {
		ast_log(LOG_ERROR, "ARI RecordingFinished missing required field recording\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_recording_finished_fn(void)
{
	return ast_ari_validate_recording_finished;
}

int ast_ari_validate_recording_started(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_recording = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingStarted field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingStarted field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingStarted field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingStarted field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("recording", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_recording = 1;
			prop_is_valid = ast_ari_validate_live_recording(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI RecordingStarted field recording failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI RecordingStarted has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI RecordingStarted missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI RecordingStarted missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI RecordingStarted missing required field timestamp\n");
		res = 0;
	}

	if (!has_recording) {
		ast_log(LOG_ERROR, "ARI RecordingStarted missing required field recording\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_recording_started_fn(void)
{
	return ast_ari_validate_recording_started;
}

int ast_ari_validate_stasis_end(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisEnd field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisEnd field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisEnd field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisEnd field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisEnd field channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI StasisEnd has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI StasisEnd missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI StasisEnd missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI StasisEnd missing required field timestamp\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI StasisEnd missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_stasis_end_fn(void)
{
	return ast_ari_validate_stasis_end;
}

int ast_ari_validate_stasis_start(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_args = 0;
	int has_channel = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisStart field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisStart field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisStart field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisStart field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("args", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_args = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisStart field args failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel = 1;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisStart field channel failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("replace_channel", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_channel(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI StasisStart field replace_channel failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI StasisStart has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI StasisStart missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI StasisStart missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI StasisStart missing required field timestamp\n");
		res = 0;
	}

	if (!has_args) {
		ast_log(LOG_ERROR, "ARI StasisStart missing required field args\n");
		res = 0;
	}

	if (!has_channel) {
		ast_log(LOG_ERROR, "ARI StasisStart missing required field channel\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_stasis_start_fn(void)
{
	return ast_ari_validate_stasis_start;
}

int ast_ari_validate_text_message_received(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_type = 0;
	int has_application = 0;
	int has_timestamp = 0;
	int has_message = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("asterisk_id", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessageReceived field asterisk_id failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("type", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_type = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessageReceived field type failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("application", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_application = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessageReceived field application failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("timestamp", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_timestamp = 1;
			prop_is_valid = ast_ari_validate_date(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessageReceived field timestamp failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("endpoint", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			prop_is_valid = ast_ari_validate_endpoint(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessageReceived field endpoint failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("message", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_message = 1;
			prop_is_valid = ast_ari_validate_text_message(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI TextMessageReceived field message failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI TextMessageReceived has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_type) {
		ast_log(LOG_ERROR, "ARI TextMessageReceived missing required field type\n");
		res = 0;
	}

	if (!has_application) {
		ast_log(LOG_ERROR, "ARI TextMessageReceived missing required field application\n");
		res = 0;
	}

	if (!has_timestamp) {
		ast_log(LOG_ERROR, "ARI TextMessageReceived missing required field timestamp\n");
		res = 0;
	}

	if (!has_message) {
		ast_log(LOG_ERROR, "ARI TextMessageReceived missing required field message\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_text_message_received_fn(void)
{
	return ast_ari_validate_text_message_received;
}

int ast_ari_validate_application(struct ast_json *json)
{
	int res = 1;
	struct ast_json_iter *iter;
	int has_bridge_ids = 0;
	int has_channel_ids = 0;
	int has_device_names = 0;
	int has_endpoint_ids = 0;
	int has_events_allowed = 0;
	int has_events_disallowed = 0;
	int has_name = 0;

	for (iter = ast_json_object_iter(json); iter; iter = ast_json_object_iter_next(json, iter)) {
		if (strcmp("bridge_ids", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_bridge_ids = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Application field bridge_ids failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("channel_ids", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_channel_ids = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Application field channel_ids failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("device_names", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_device_names = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Application field device_names failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("endpoint_ids", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_endpoint_ids = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_string);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Application field endpoint_ids failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("events_allowed", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_events_allowed = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_object);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Application field events_allowed failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("events_disallowed", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_events_disallowed = 1;
			prop_is_valid = ast_ari_validate_list(
				ast_json_object_iter_value(iter),
				ast_ari_validate_object);
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Application field events_disallowed failed validation\n");
				res = 0;
			}
		} else
		if (strcmp("name", ast_json_object_iter_key(iter)) == 0) {
			int prop_is_valid;
			has_name = 1;
			prop_is_valid = ast_ari_validate_string(
				ast_json_object_iter_value(iter));
			if (!prop_is_valid) {
				ast_log(LOG_ERROR, "ARI Application field name failed validation\n");
				res = 0;
			}
		} else
		{
			ast_log(LOG_ERROR,
				"ARI Application has undocumented field %s\n",
				ast_json_object_iter_key(iter));
			res = 0;
		}
	}

	if (!has_bridge_ids) {
		ast_log(LOG_ERROR, "ARI Application missing required field bridge_ids\n");
		res = 0;
	}

	if (!has_channel_ids) {
		ast_log(LOG_ERROR, "ARI Application missing required field channel_ids\n");
		res = 0;
	}

	if (!has_device_names) {
		ast_log(LOG_ERROR, "ARI Application missing required field device_names\n");
		res = 0;
	}

	if (!has_endpoint_ids) {
		ast_log(LOG_ERROR, "ARI Application missing required field endpoint_ids\n");
		res = 0;
	}

	if (!has_events_allowed) {
		ast_log(LOG_ERROR, "ARI Application missing required field events_allowed\n");
		res = 0;
	}

	if (!has_events_disallowed) {
		ast_log(LOG_ERROR, "ARI Application missing required field events_disallowed\n");
		res = 0;
	}

	if (!has_name) {
		ast_log(LOG_ERROR, "ARI Application missing required field name\n");
		res = 0;
	}

	return res;
}

ari_validator ast_ari_validate_application_fn(void)
{
	return ast_ari_validate_application;
}
